#include <iostream>

using namespace std;

#define DESNO 'D'
#define DOLE 'S'

string K0(int N, int M)
{
    int Kragujevac[N][M];
    string Resenje = "";
    for(int i = 0; i<N; i++)
    {
        string s;
        cin>>s;
        for(int j = 0; j<M; j++)
        {
            Kragujevac[i][j]=s[j]-'0';
        }
    }

    for(int i = N-1; i>-1; i--)
    {
        for(int j = M-1; j>-1; j--)
        {
            if(!Kragujevac[i][j])
            {
                if(j<M-1 && i<N-1)
                {
                    Kragujevac[i][j] = min(Kragujevac[i][j+1],Kragujevac[i+1][j]);
                }
                else if(j<M-1)
                {
                    Kragujevac[i][j] = Kragujevac[i][j+1];
                }
                else if(i<N-1)
                {
                    Kragujevac[i][j] = Kragujevac[i+1][j];
                }
            }

        }
    }

    if(Kragujevac[0][0])
    {
        return "";
    }
    int i = 0;
    int j = 0;
    while(i<N-1 || j<M-1)
    {
        if(i<N-1)
        {
            if(!Kragujevac[i+1][j])
            {
                i++;
                Resenje+=DOLE;
                continue;
            }
        }
        if(j<M-1)
        {
            if(!Kragujevac[i][j+1])
            {
                j++;
                Resenje+=DESNO;
                continue;
            }
        }
    }
    return Resenje;

}

string Podprimer()
{
    int N,M,K;
    cin>>N>>M>>K;
    if(!K)
    {
        return K0(N,M);
    }
    int Kragujevac[N][M];
    bool Moguce = false;
    int MogucI[N*M], MogucJ[N*M];
    int Brojac = 0;
    string Resenje = "";

    for(int i = 0; i<N; i++)
    {
        string s;
        cin>>s;
        for(int j = 0; j<M; j++)
        {
            Kragujevac[i][j]=s[j]-'0';
            if(i && j)
            {
                Kragujevac[i][j]+=min(Kragujevac[i-1][j],Kragujevac[i][j-1]);
            }
            else if(i)
            {
                Kragujevac[i][j]+=Kragujevac[i-1][j];
            }
            else if(j)
            {
                Kragujevac[i][j]+=Kragujevac[i][j-1];
            }
            if(Kragujevac[i][j]==K)
            {
                MogucI[Brojac] = i;
                MogucJ[Brojac] = j;
                Moguce = true;
                Brojac++;
            }
        }
    }
    if(Kragujevac[N-1][M-1]>K)
    {
        return "";
    }
    if(!Moguce)
    {
        return "";
    }
    int Najblizi = 0;
    for(int k = 0; k<Brojac; k++)
    {
        if(MogucI[k]+MogucJ[k]>MogucI[Najblizi]+MogucJ[Najblizi])
        {
            Najblizi = k;
        }
    }

    int i = N-1;
    int j = M-1;
    while(i>MogucI[Najblizi] || j>MogucJ[Najblizi])
    {
        if(i>MogucI[Najblizi])
        {
            if(Kragujevac[i-1][j]==Kragujevac[i][j])
            {
                i--;
                Resenje+=DOLE;
                continue;
            }
        }
        if(j>MogucJ[Najblizi])
        {
            if(Kragujevac[i][j+1]==Kragujevac[i][j])
            {
                j--;
                Resenje+=DESNO;
                continue;
            }
        }
        Resenje = "";
        break;
    }
    while(i>0 || j>0)
    {
        if(i>0 && j>0)
        {
            if(Kragujevac[i-1][j]<=Kragujevac[i][j] && Kragujevac[i-1][j]<=Kragujevac[i][j-1])
            {
                i--;
                Resenje+=DOLE;
                continue;
            }
            else if(Kragujevac[i][j+1]<=Kragujevac[i][j])
            {
                j--;
                Resenje+=DESNO;
                continue;
            }
        }
        else if(i>0)
        {
            if(Kragujevac[i-1][j]<=Kragujevac[i][j])
            {
                i--;
                Resenje+=DOLE;
                continue;
            }
        }
        else if(j>0)
        {
            if(Kragujevac[i][j+1]<=Kragujevac[i][j])
            {
                j--;
                Resenje+=DESNO;
                continue;
            }
        }
        Resenje = "";
        break;
    }
    string PravoResenje="";
    for(int k = M+N-3; k>=0; k--)
    {
        PravoResenje+=Resenje[k];
    }

    return PravoResenje;
}

int main()
{
    int T, Z;
    cin>>T>>Z;
    string Resenja[T];
    for(int t = 0; t<T; t++)
    {
        Resenja[t] = Podprimer();
    }
    for(int t = 0; t<T; t++)
    {
        if(Resenja[t]=="")
        {
            cout<<"NE"<<endl;
        }
        else if(Z)
        {
            cout<<"DA"<<endl<<Resenja[t]<<endl;
        }
        else
        {
            cout<<"DA"<<endl;
        }
    }
    return 0;
}